#define debug

using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace ReactionTimer
{
    /// <summary>
    /// To jest gwny typ dla naszej gry
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        // wiat Gry

        // Wywietlana czcionka
        SpriteFont font;

        // Pomiar czasu gry
        int timer;

        int[] scores = new int[4];

        // Pasujce nazwy przyciskw
        string[] names = new string[] {
            "Gamepad 1 A",
            "Gamepad 1 B",
            "Gamepad 1 X",
            "Gamepad 1 Y"
        };

        string winnerName = "";
        Vector2 winnerPos = new Vector2(150, 400);

        // Dwiki wiata gry
        SoundEffect dingSound;

        // Gamepad 1
        GamePadState pad1;
        GamePadState oldpad1;
        Vector2 apos1 = new Vector2(150, 150);
        Vector2 bpos1 = new Vector2(200, 100);
        Vector2 xpos1 = new Vector2(100, 100);
        Vector2 ypos1 = new Vector2(150, 50);

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Pozwala grze wykona dowoln inicjalizacj jakiej potrzebuje przed rozpoczeciem dziaania.
        /// To tutaj moe ona zada potrzebnych usug i zaadowa zwizan zawarto nie graficzn.
        /// Wywoanie base.Initialize wyliczy wszystkie komponenty i take je zainicjuje.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Dodaj w tym miejscu swoj logik inicjalizacji

            base.Initialize();
        }

        /// <summary>
        /// LoadContent bedzie wywoany raz na gr i tu naley adowa
        /// ca zawarto.
        /// </summary>
        protected override void LoadContent()
        {
            // Stwrz nowy SpriteBatch, ktrego mona uzy do rysowania tekstur.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            dingSound = Content.Load<SoundEffect>("ding");
            font = Content.Load<SpriteFont>("SpriteFont1");
        }

        /// <summary>
        /// UnloadContent bedzie wywoany raz na gr i tu naley usuwa 
        /// ca zawarto.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Usun w tym miejscu kad zawarto nie obsugiwan przez ContentManager
        }

        /// <summary>
        /// Pozwala uruchomi w grze logik, tak jak aktualizacja wiata,
        /// sprawdzenie kolizji, pobranie wejcia i odtwarzanie dwiku.
        /// </summary>
        /// <param name="gameTime">Dostarcza chwilow warto zmiennych czasowych.</param>
        protected override void Update(GameTime gameTime)
        {
            pad1 = GamePad.GetState(PlayerIndex.One);

            if (pad1.Buttons.Back == ButtonState.Pressed)
            {
                this.Exit();
            }

            // rozpocznij now gr
            if (pad1.Buttons.Start == ButtonState.Pressed)
            {
                for (int i = 0; i < 4; i++)
                {
                    scores[i] = 0;
                }
                winnerName = "";
                timer = -120;
            }

            // aktualizuj zegar
            timer++;

            // odtwrz  dwik rozpoczynnajcy gr
            if (timer == 0)
            {
                dingSound.Play();
            }


            // jeli przycisk A jest wcisnity, skopiuj zegar
            if (oldpad1.Buttons.A == ButtonState.Released &&
                 pad1.Buttons.A == ButtonState.Pressed && scores[0] == 0)
            {
                scores[0] = timer;
            }

            if (oldpad1.Buttons.B == ButtonState.Released &&
                 pad1.Buttons.B == ButtonState.Pressed && scores[1] == 0)
            {
                scores[1] = timer;
            }

            if (oldpad1.Buttons.X == ButtonState.Released &&
                 pad1.Buttons.X == ButtonState.Pressed && scores[2] == 0)
            {
                scores[2] = timer;
            }

            if (oldpad1.Buttons.Y == ButtonState.Released &&
                 pad1.Buttons.Y == ButtonState.Pressed && scores[3] == 0)
            {
                scores[3] = timer;
            }

            oldpad1 = pad1;

            if (timer == 120)
            {
                int winningValue = 120;
                int winnerSubscript = 0;
                for (int i = 0; i < 4; i++)
                {
                    if (scores[i] > 0)
                    {
                        if (scores[i] < winningValue)
                        {
                            winningValue = scores[i];
                            winnerSubscript = i;
                        }
                    }
                }

                if (winningValue != 120)
                {
                    winnerName = names[winnerSubscript];
                }
                else
                {
                    winnerName = "**NO WINNER**";
                }
            }

            base.Update(gameTime);
        }

        /// <summary>
        /// Metoda wywoywana kiedy gra powinna si wyswietli.
        /// </summary>
        /// <param name="gameTime">Dostarcza chwilow warto zmiennych czasowych.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            spriteBatch.Begin();

            if (pad1.IsConnected)
            {
                spriteBatch.DrawString(font, scores[0].ToString(), apos1, Color.Green);
                spriteBatch.DrawString(font, scores[1].ToString(), bpos1, Color.Red);
                spriteBatch.DrawString(font, scores[2].ToString(), xpos1, Color.Blue);
                spriteBatch.DrawString(font, scores[3].ToString(), ypos1, Color.Yellow);
            }

            spriteBatch.DrawString(font, winnerName, winnerPos, Color.White);

            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}
